﻿namespace Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Tests
{
    using System;
    using Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Notifications;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass]
    public class FileTemplateReaderFixture
    {
        [TestMethod]
        [DeploymentItem("Notifications\\MailTestTemplate_TXT.txt")]
        public void RetrieveTemplate()
        {
            var reader = new FileTemplateReader(Environment.CurrentDirectory);
            var template = reader.RetrieveTemplate("MailTestTemplate_TXT");
            Assert.IsTrue(!string.IsNullOrEmpty(template));
        }

        [TestMethod]
        public void RetrieveTemplateOnUnexistingTemplateReturnsNull()
        {
            var reader = new FileTemplateReader(Environment.CurrentDirectory);
            var template = reader.RetrieveTemplate("xxxx");
            Assert.IsNull(template);
        }
    }
}
